----------------
title : C++ 레퍼런스 - fill 함수 (<algorithm>)
cat_title : fill
ref_title : fill, std::fill
path : /C++ Reference/algorithm
publish_date : 2019-02-18
----------------

##@ cpp-ref-start

#@ fill

`<algorithm>` 에 정의됨

```cpp-formatted
template <class ForwardIterator, class T>
void fill(ForwardIterator first, ForwardIterator last, const T& val);
```

범위 내의 원소들을 `val` 로 채운다.

범위 내 (`first` 부터 `last` 전 까지) 원소들에 `val` 을 대입합니다. 이 때 대입을 위해 `operator=` 가 사용됩니다.

### 인자들

* `first, last` : 값을 대입할 원소들의 시작과 끝을 가리키는 반복자들. 이 때 확인하는 범위는 `[first, last)` 로 정의됩니다. `first` 가 가리키는 원소는 포함되지만 `last` 가 가리키는 원소는 포함되지 않습니다.
* `val` : 어떤 값을 대입할 지

### 리턴값

없음

### 구현 예시

```cpp-formatted
template <class ForwardIterator, class T>
void fill(ForwardIterator first, ForwardIterator last, const T& val) {
  while (first != last) {
    *first = val;
    ++first;
  }
}
```

### 실행 예제

```cpp-formatted
#include <algorithm>  // std::fill
#include <iostream>   // std::cout
#include <vector>     // std::vector

int main() {
  // myvector: 0 0 0 0 0 0 0 0
  std::vector<int> myvector(8);

  // myvector: 5 5 5 5 0 0 0 0
  std::fill(myvector.begin(), myvector.begin() + 4, 5);

  // myvector: 5 5 5 8 8 8 0 0
  std::fill(myvector.begin() + 3, myvector.end() - 2, 8);

  std::cout << "myvector contains:";
  for (std::vector<int>::iterator it = myvector.begin(); it != myvector.end();
       ++it)
    std::cout << ' ' << *it;
  std::cout << '\n';

  return 0;
}
```

실행 결과

```exec
myvector contains: 5 5 5 8 8 8 0 0
```

### 참고 자료

* `fill_n` : 특정 범위의 n 개의 원소를 값으로 채운다.
* `generate` : 특정 범위를 어떤 함수를 계속 호출해서 채운다.
* `for_each` : 범위 안에 원소들 각각에 대해 전달된 함수를 호출한다.
* `replace$algorithm` : 특정 범위의 원소들을 치환한다.